package gov.va.med.mhv.sm.admin.exception;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SMApiException extends Exception{
	
	private static final int STACK_TRACE_LIMIT = 5;
	
	private Map<String, String> errorMessages = new HashMap<String, String>();
	private Map<String, String> validationErrorMessages = new HashMap<String, String>();
	private Map<String, String> infoMessages = new HashMap<String, String>();
	private String failureMessage;
	
	private Integer httpCode;

	public SMApiException() {
		super();
	}

	public SMApiException(Map<String, String> errorMessages,
			Map<String, String> validationErrorMessages,
			Map<String, String> infoMessages, Integer httpCode, Throwable e ) {
		super(e);
		this.errorMessages = errorMessages;
		this.validationErrorMessages = validationErrorMessages;
		this.infoMessages = infoMessages;
		this.httpCode = httpCode;
	}

	public SMApiException(Map<String, String> errorMessages,
			Map<String, String> validationErrorMessages,
			Map<String, String> infoMessages, Integer httpCode) {
		super();
		this.errorMessages = errorMessages;
		this.validationErrorMessages = validationErrorMessages;
		this.infoMessages = infoMessages;
		this.httpCode = httpCode;
	}

	public SMApiException(String failureMessage, Integer httpCode, Throwable e) {
		super(failureMessage, e);
		this.httpCode = httpCode;
	}
	
	public SMApiException(String failureMessage, Integer httpCode) {
		super(failureMessage);
		this.httpCode = httpCode;
	}
	
	public Map<String, String> getErrorMessages() {
		return errorMessages;
	}

	public void setErrorMessages(Map<String, String> errorMessages) {
		this.errorMessages = errorMessages;
	}

	public Map<String, String> getValidationErrorMessages() {
		return validationErrorMessages;
	}

	public void setValidationErrorMessages(
			Map<String, String> validationErrorMessages) {
		this.validationErrorMessages = validationErrorMessages;
	}

	public Map<String, String> getInfoMessages() {
		return infoMessages;
	}

	public void setInfoMessages(Map<String, String> infoMessages) {
		this.infoMessages = infoMessages;
	}

	public Integer getHttpCode() {
		return httpCode;
	}

	public void setHttpCode(Integer httpCode) {
		this.httpCode = httpCode;
	}

	public String getFailureMessage() {
		return failureMessage;
	}

	public void setFailureMessage(String failureMessage) {
		this.failureMessage = failureMessage;
	}
	
	@Override
	public StackTraceElement[] getStackTrace() {
		StackTraceElement[] stkTraceElement = super.getStackTrace();
		return Arrays.copyOf(stkTraceElement, STACK_TRACE_LIMIT);
	}

	

}
